C********************************************************************


      SUBROUTINE USRMTR(NPTRTN,YS,YPS,FIP,TEPS,EFEPS,TEMP)
C********************************************************************
C
C     THIS SUBROUTINE CALCULATES THE FLOW STRESS OF PLASTIC MATERIAL
C
C     INPUT :
C
C      NPTRTN    =   FLOW STRESS NUMBER
C      TEPS      =   EFFECTIVE STRAIN
C      EFEPS     =   EFFECTIVE STRAIN RATE
C      TEMP      =   TEMPERATURE
C
C     OUTPUT :
C
C      YS        =   FLOW STRESS
C      YPS       =   DERIVATIVE OF FLOW STRESS W.R.T TEPS
C      FIP       =   DERIVATIVE OF FLOW STRESS W.R.T. EFEPS
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C  USER SUPPLIED SUBROUTINES
C
C
C ****    USER DEFINED VARIABLES ****
C
      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C     
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     Version 5.1
C
C     COMMON /ELMCOM/ RZE(2,4),URZE(2,4),STSE(4),EPSE(4),EFEPSE,EFSTSE,

C    +                TEPSE,RDTYE,TEMPE(4),DTMPE(4),USRE1(2),USRE2(2),
C    +                NODEE(4),KELE
C
C     Version 6.0
C
C     COMMON /ELMCOM/
C
C         RZE     : Four corner coordinates
C         URZE    : Velocity
C         STSE    : Stress
C         EPSE    : Strain rate
C         EFEPSE  : effective strain rate
C         EFSTSE  : Effective stress
C         TEPSE   : Total effective strain
C         RDTYE   : Density
C         TEMPE   : Temperature
C         DTMPE   : Temperature rate
C         DAMAGE  : Damage value
C         USRE1   : Element user variable at the begining of step 
C         USRE2   : Element user variable at the end of the step 
C         USRNE   : Nodal user state variables at 4 nodes
C         NODEE   : Connectivity
C         KELE    : Global element number
C         KELEL   : Local element number
C         KGROUP  : Material group number
C
      COMMON /ELMCOM/ RZE(2,4),URZE(2,4),STSE(6),EPSE(6),EFEPSE,EFSTSE,
     +                TEPSE,RDTYE,TEMPE(4),DTMPE(4),DAMAGE,
     +                USRE1(1500),USRE2(1500),
     +                USRNE(1500,4),NODEE(4),KELE,KELEL,KGROUP


C
C     COMMON /NODCOM/
C
C        RZN      : Nodal point coordinates
C        URZN     : Nodal point velocities
C        DRZN     : Nodal point displacement
C        TEMPN    : Nodal point temperature
C        USRN1    : User defined state variables (Input : At the beginning of Step N)
C        USRN2    : User defined state variables (Output: At the end of Step N)
C        KNODE    : Node number
C
      COMMON /NODCOM/ RZN(2),URZN(2),DRZN(2),TEMPN,DTMPN,USRN1(1500),
     +                USRN2(1500),KNODE

C
C     CURTIM: CURRENT TIME           
C      
      COMMON /CLOK/ CURTIM
C
C     DTMAXC: CURRENT TIME STEP SIZE
C
      COMMON /SSTU/ DTMAXC
C
C
C     COMMON /USRCTL/
C
C        KOBJ      : Object number
C        KSTEP     : Step number (N)
C        ISTATUS   : 0 - the beginning of the step
C                    1 - the end of the step
C        KSSTEP    : negative step indication -1 for negative step 1 for else
C
C     WHEN (ISTATUS.EQ. 1)  --> USRE2/USRN2 should be updated here
C     KELE  > 0             --> Element data is active
C     INODE > 0             --> Node Data is active
C
      COMMON /USRCTL/ KOBJ,ISTATUS,KSTEP,KSSTEP
C
C
C     Branching to proper flow stress routine based on the
C     number specified in the pre-processor
C     
C
      GO TO (510,520,530,540,550,560,570,580,590,600),NPTRTN 
C     
  510 CALL UFLOW1(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
  520 CALL UFLOW2(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
  530 CALL UFLOW3(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
  540 CALL UFLOW4(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
  550 CALL UFLOW5(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
  560 CALL UFLOW6(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
  570 CALL UFLOW7(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
  580 CALL UFLOW8(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
  590 CALL UFLOW9(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
  600 CALL UFLOW10(YS,YPS,FIP,TEPS,EFEPS,TEMP)
      RETURN
C
C  TO BE CONTINUED BY USER
C
      END
C********************************************************************

      SUBROUTINE UFLOW1(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C TANH-model
C Dr. Sampsa Laakso
C sampsa.laakso@aalto.fi
C
C********************************************************************
      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N) 

C
C ****    USER DEFINED VARIABLES ****
C
      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)

      COMMON /ELMCOM/ RZE(2,4),URZE(2,4),STSE(6),EPSE(6),EFEPSE,EFSTSE,
     +                TEPSE,RDTYE,TEMPE(4),DTMPE(4),DAMAGE,
     +                USRE1(1500),USRE2(1500),
     +                USRNE(1500,4),NODEE(4),KELE,KELEL,KGROUP

      COMMON /SSTU/ DTMAXC

     
      READ(IUSRVL(1),*) Aa, Bb, Pn, Cc, De_r, T_r, T_m, Pm, Pr, Pd,
     & Pb, PS
     
      IF(EFEPS.LE.De_r) THEN
      EFE0=De_r
      ELSE
      EFE0=EFEPS
      ENDIF
     
      STR0=Aa+Bb*(TEPS**Pn)
      STRD0=Bb*Pn*(TEPS**(Pn-1.0D0))
      RAT0=(1.0D0)+Cc*DLOG(EFE0/De_r)
      RATD0=Cc/EFE0
      TS0=(1.0D0)-(((TEMP-T_r)/(T_m-T_r))**Pm)
      DD=1.0D0-(TEMP/T_m)**Pd
      PP=(TEMP/T_m)**Pb
      HT=DD+(1.0D0-DD)*(dtanh((TEPS+PP)**(-Pr)))**PS
      HTD=(1.0D0-DD)*SS*Pr*(dtanh((TEPS+PP)**(-Pr))**(SS-1.0D0))*
     &((dtanh((TEPS+PP)**(-Pr))**2.0D0)-1.0D0)/
     &((TEPS+PP)**(Pr+1.0D0))
      
      YS =STR0*RAT0*TS0*HT
      YPS =STRD0*RAT0*TS0*HT+STR0*RAT0*TS0*HTD
      FIP =STR0*RATD0*TS0*HT
C
C     OUTPUT :
C
C      YS        =   FLOW STRESS
C      YPS       =   DERIVATIVE OF FLOW STRESS W.R.T TEPS
C      FIP       =   DERIVATIVE OF FLOW STRESS W.R.T. EFEPS
C
      RETURN
      END
C********************************************************************

      SUBROUTINE UFLOW2(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C
C ****    USER DEFINED VARIABLES ****

      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C
C     SEE UFLOW1 FOR DETAILED DESCRIPTION 
C
      RETURN
      END
C********************************************************************

      SUBROUTINE UFLOW3(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C
C ****    USER DEFINED VARIABLES ****

      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE UFLOW1 FOR DETAILED DESCRIPTION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE UFLOW4(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C
C ****    USER DEFINED VARIABLES ****

      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE UFLOW1 FOR DETAILED DESCRIPTION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE UFLOW5(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C ****    USER DEFINED VARIABLES ****

      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE UFLOW1 FOR DETAILED DESCRIPTION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE UFLOW6(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C ****    USER DEFINED VARIABLES ****

      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE UFLOW1 FOR DETAILED DESCRIPTION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE UFLOW7(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C ****    USER DEFINED VARIABLES ****

      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE UFLOW1 FOR DETAILED DESCRIPTION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE UFLOW8(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C ****    USER DEFINED VARIABLES ****

      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE UFLOW1 FOR DETAILED DESCRIPTION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE UFLOW9(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C ****    USER DEFINED VARIABLES ****

      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE UFLOW1 FOR DETAILED DESCRIPTION
C
      RETURN
      END
C********************************************************************

      SUBROUTINE UFLOW10(YS,YPS,FIP,TEPS,EFEPS,TEMP)

C********************************************************************
C
C
C
C********************************************************************

      IMPLICIT REAL*8 (A-H,O-Z), INTEGER*4 (I-N)
C
C ****    USER DEFINED VARIABLES ****

      CHARACTER*80 IUSRVL
      COMMON /IUSR/ IUSRVL(10)
C
C     TO READ DATA (10 RESERVED LINES)
C        READ(IUSRVL(LINE NUMBER),*) DATA1,DATA2,DATA3...
C
C     TO WRITE DATA (10 RESERVED LINES)
C        WRITE(IUSRVL(LINE NUMBER),*) NEWDATA1, NEWDATA2, NEWDATA3 ...
C
C ****     END    ****
C
C     SEE UFLOW1 FOR DETAILED DESCRIPTION
C
      RETURN
      END
C********************************************************************
